/******************************************************************************
 * %Id: ipr_bridge_data.h,v 1.35 2010/02/15 06:26:20 ishikawa Exp $
 *
 * FileName		:ipr_bridge_data.h
 *
 * Description	:Data definition header for bridge
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_EXIV_BRIDGE_DATA_H_
#define	_EXIV_BRIDGE_DATA_H_


/********************************
*       Include File(s)         *
********************************/


/* event handler table */
typedef struct {
	int	cmd;
	int	(*handler)(int, unsigned int, void *);
} exiv_command_t;



/*******************/
/* API args struct */
/*******************/
typedef struct {
	int	async_flag;
	int	error;
} exiv_void_arg_t;

/*-----------------*/
/* library control */
/*-----------------*/
typedef exiv_void_arg_t		exiv_init_arg_t;
typedef exiv_void_arg_t		exiv_term_arg_t;

typedef struct {
	int	async_flag;
	int	error;
	struct {
		int		dev_id;
	} args;
} exiv_open_arg_t;

typedef struct {
	int	async_flag;
	int	error;
	struct {
		int		dev_id;
	} args;
} exiv_close_arg_t;

/*---------------*/
/* input setting */
/*---------------*/
/* common */
typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_port_t	port;
	} args;
} exiv_set_port_arg_t;


typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_input_format_t	input;
	} args;
} exiv_set_input_format_arg_t;

typedef exiv_set_input_format_arg_t		exiv_get_input_format_arg_t;

typedef struct {
	int	async_flag;
	int	error;
	struct {
		UB		level;
	} args;
} exiv_set_video_pll_level_arg_t;


typedef struct {
	int	async_flag;
	int	error;
	struct {
		UH	pos;
	} args;
} exiv_set_video_cgms_position_arg_t;


/* CVBS/YC,scart */
typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_killer_t	data;
	} args;
} exiv_set_killer_adjust_arg_t;

typedef exiv_set_killer_adjust_arg_t exiv_get_killer_adjust_arg_t;

typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_3dyc_state_t	on_off;
	} args;
} exiv_set_3dyc_onoff_arg_t;

typedef exiv_set_3dyc_onoff_arg_t	exiv_get_3dyc_onoff_arg_t;


typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_3dyc_adjust_t	data;
	} args;
} exiv_set_3dyc_adjust_arg_t;

typedef exiv_set_3dyc_adjust_arg_t	exiv_get_3dyc_adjust_arg_t;





/* YPbPr */

/* RGB */
typedef struct {
	int	async_flag;
	int	error;
	struct {
		UH	data;
	} args;
} exiv_set_video_dot_clock_arg_t;


typedef struct {
	int	async_flag;
	int	error;
	struct {
		UB	data;
	} args;
} exiv_set_video_clock_phase_arg_t;


typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_video_hv_position_t	pos;
	} args;
} exiv_set_video_hv_position_arg_t;


/* HDMI */
typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_hdmirx_power_t		power;
	} args;
} exiv_set_hdmirx_power_arg_t;





typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_csc_round_t	round_type;
	} args;
} exiv_set_csc_round_arg_t;

typedef struct {
	int async_flag;
	int error;
	struct {
		EXIV_std_sig_det_t    data;
	} args;
} exiv_get_std_sig_det_arg_t;

typedef struct {
	int async_flag;
	int error;
	struct {
		EXIV_type_t    type;
	} args;
} exiv_set_format_detect_arg_t;



/*----------------*/
/* output setting */
/*----------------*/
typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_output_format_t	output;
	} args;
} exiv_set_output_format_arg_t;


typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_mute_t		mute;
	} args;
} exiv_set_video_mute_arg_t;


typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_video_level_t	level;
	} args;
} exiv_set_video_level_arg_t;



typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_port_t		src;
	} args;
} exiv_select_vout_src_arg_t;



/*--------------*/
/* input status */
/*--------------*/
/* common */
typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_input_signal_info_t	input;
	} args;
} exiv_get_input_signal_info_arg_t;


#ifdef EXIV_ENABLE_BACKUP_INPUT
typedef struct {
	int async_flag;
	int error;
	struct {
		EXIV_port_t         port;
	} args;
} exiv_set_backup_port_arg_t;

typedef struct {
	int async_flag;
	int error;
	struct {
		EXIV_backup_input_t onoff;
		EXIV_type_t         type;
	} args;
} exiv_set_backup_input_arg_t;

typedef struct {
	int async_flag;
	int error;
	struct {
		EXIV_input_signal_info_t info;
	} args;
} exiv_get_backup_input_arg_t;
#endif //EXIV_ENABLE_BACKUP_INPUT

/* CVBS/YC,YPbPr */
typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_det_pin_t	port;
		EXIV_aspect_t	data;
	} args;
} exiv_get_video_aspect_info_arg_t;

/* RGB */
typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_pc_format_t	pact;
	} args;
} exiv_measure_pc_signal_arg_t;

typedef struct {
	int	async_flag;
	int	error;
	struct {
		UW	phase;
	} args;
} exiv_measure_pc_phase_arg_t;

/* HDMI */
typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_hdmirx_packet_type_t	type;
		EXIV_hdmirx_packet_state_t	state;
		EXIV_packet_info_t			info;
	} args;
} exiv_get_hdmirx_packet_info_arg_t;


/* VBI */
typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_vbi_port_t vbi_port;
		EXIV_vbi_format_t vbi_format;
		EXIV_vbi_cb_t func;
	} args;
} exiv_start_vbi_arg_t;

typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_vbi_port_t vbi_port;
	} args;
} exiv_stop_vbi_arg_t;

typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_vbi_port_t vbi_port;
		EXIV_vbi_vps_onoff_t on_off;
	} args;
} exiv_set_vps_acq_arg_t;

typedef exiv_set_vps_acq_arg_t exiv_get_vps_acq_arg_t;


typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_hdmirx_cb_t	cb;
	} args;
} exiv_set_hdmirx_callback_arg_t;

typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_hdmirx_packet_state_t	state;
		EXIV_hdmirx_audio_info_t	info;
	} args;
} exiv_get_hdmirx_audio_info_arg_t;


/************************/
/* CALLBACK args struct */
/************************/
typedef struct {
	int	dev_id;
	int	cmd;
	union {
		exiv_void_arg_t								void_arg;
		exiv_init_arg_t								init;
		exiv_term_arg_t								term;
		exiv_open_arg_t								open;
		exiv_close_arg_t							close;
		exiv_set_port_arg_t							set_port;
		exiv_set_input_format_arg_t					set_input_format;
		exiv_get_input_format_arg_t					get_input_format;
		exiv_set_video_pll_level_arg_t				set_video_pll_level;
		exiv_set_video_cgms_position_arg_t			set_video_cgms_position;
		exiv_set_killer_adjust_arg_t				set_killer_adjust;
		exiv_get_killer_adjust_arg_t				get_killer_adjust;
		exiv_set_3dyc_onoff_arg_t					set_3dyc_onoff;
		exiv_get_3dyc_onoff_arg_t					get_3dyc_onoff;
		exiv_set_3dyc_adjust_arg_t					set_3dyc_adjust;
		exiv_get_3dyc_adjust_arg_t					get_3dyc_adjust;
		exiv_set_video_dot_clock_arg_t				set_video_dot_clock;
		exiv_set_video_clock_phase_arg_t			set_video_clock_phase;
		exiv_set_hdmirx_power_arg_t					set_hdmirx_power;
		exiv_set_output_format_arg_t				set_output_format;
		exiv_set_video_mute_arg_t					set_video_mute;
		exiv_set_video_level_arg_t					set_video_level;
		exiv_select_vout_src_arg_t					select_vout_src;
		exiv_get_input_signal_info_arg_t			get_input_signal_info;
		exiv_get_video_aspect_info_arg_t			get_video_aspect_info;
		exiv_measure_pc_signal_arg_t				measure_pc_signal;
		exiv_measure_pc_phase_arg_t					measure_pc_phase;
		exiv_get_hdmirx_packet_info_arg_t			get_hdmirx_packet_info;
		exiv_set_hdmirx_callback_arg_t				set_hdmirx_callback;
		exiv_get_hdmirx_audio_info_arg_t			get_hdmirx_audio_info;
		exiv_start_vbi_arg_t						start_vbi;
		exiv_stop_vbi_arg_t							stop_vbi;
		exiv_set_vps_acq_arg_t						set_vps_acq;
	} arg;
} exiv_api_finish_cb_arg_t;



/* VBI */
typedef struct {
	int	dev_id;
	union {
		EXIV_vbi_packet_t	pkt_data;
	} arg;
} exiv_vbi_slice_cb_arg_t;

typedef struct {
	BOOL						valid;
	EXIV_hdmirx_video_state_t   state;
	EXIV_hdmirx_video_info_t	data;
} EXIV_hdmirx_video_info_arg_t;

typedef struct {
	BOOL						valid;
	EXIV_hdmirx_packet_state_t  state;
	EXIV_hdmirx_audio_info_t	data;
} EXIV_hdmirx_audio_info_arg_t;

typedef struct {
	BOOL						valid;
	EXIV_hdmirx_packet_type_t   type;
	EXIV_hdmirx_packet_state_t  state;
	EXIV_packet_info_t			data;
} EXIV_hdmirx_packet_info_arg_t;

typedef struct {
	BOOL						valid;
	EXIV_port_t					port[4];
	EXIV_ONOFF_t				state[4];
} EXIV_hdmirx_det5v_info_arg_t;

typedef struct {
	BOOL						valid;
	EXIV_port_t					port[4];
	EXIV_ONOFF_t				state[4];
} EXIV_hdmirx_hpdet_info_arg_t;

typedef struct {
	BOOL						valid;
	UB							data[EXIV_HDMI_KSV_NUM];
} EXIV_hdmirx_bksv_info_arg_t;

typedef struct {
	BOOL						valid;
	EXIV_mute_t					mute;
} EXIV_hdmirx_avmute_info_arg_t;


typedef struct {
	int	dev_id;
	struct {
		EXIV_hdmirx_video_info_arg_t	video;
		EXIV_hdmirx_audio_info_arg_t	audio;
		EXIV_hdmirx_packet_info_arg_t	packet;
		EXIV_hdmirx_det5v_info_arg_t	det5v;
		EXIV_hdmirx_hpdet_info_arg_t	hpdet;
		EXIV_hdmirx_bksv_info_arg_t		bksv;
		EXIV_hdmirx_avmute_info_arg_t	avmute;
	} arg;
} exiv_hdmirx_callback_info_arg_t;

typedef struct {
	int	async_flag;
	int	error;
	struct {
		EXIV_enc_status_info_t state;
	} args;
} exiv_get_hdmirx_enc_status_arg_t;

typedef struct {
	struct {
		EXIV_color_format_t format;
	} arg;
} exiv_set_analog_dmd_call_arg_t;

#endif	/* #ifndef	_EXIV_BRIDGE_DATA_H_ */
